SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_AddRecording]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_AddRecording]
GO

CREATE PROCEDURE VX_sp_AddRecording
  @_Respondent varchar(10),
  @_rpsQuestion nvarchar(32),
  @_rpsMatrix bigint,
  @_rpsMention int,
  @_CallCount int,
  @_Interviewer int, -- Case of IVRmmServer
  @_FileName nvarchar(256),
  @RecordId int = null OUT
AS
BEGIN
SET NOCOUNT ON;
DECLARE @InsertedRecord table(RecordId int);

INSERT INTO [dbo].[Recording] 
    ( Respondent, rpsQuestion, rpsMatrix, rpsMention, CallCount, RecordDate, Interviewer, FileName)
    OUTPUT inserted.RecordId INTO @InsertedRecord
    VALUES (@_Respondent, @_rpsQuestion, @_rpsMatrix, @_rpsMention, @_CallCount, getutcdate(), @_Interviewer, @_FileName)
    SELECT @RecordId = RecordId FROM @InsertedRecord
END
GO
